/* Antarmuka dengan Sensor BMP180 - Trainer Internet of Things
 * Project : Monitoring dengan Sensor BMP180
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>
// Library OLED Display
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
// Library BMP180
#include <Adafruit_BMP085.h>

// Mengatur OLED Display dengan resolusi 128x64
#define SCREEN_WIDTH 128
#define SCREEN_HEIGHT 64
#define OLED_RESET    -1
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// BMP objek dengan nama bmp
Adafruit_BMP085 bmp;

// Variabel jarak menyimpan nilai sensor BMP180     
int temperature;
int pressure;
int altitude;

// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200); 
  
  // Memulai komunikasi dengan sensor BMP180
  bmp.begin();
  // Memulai komunikasi dengan OLED Display
  display.begin(SSD1306_SWITCHCAPVCC, 0x3C);
  
  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);

  // Membersihkan tampilan display
  display.clearDisplay();
}

void loop() {
  // Membaca data suhu, tekanan dan ketinggian 
  temperature = bmp.readTemperature();
  pressure = bmp.readPressure()/100;
  altitude = bmp.readAltitude();

  // Mencetak data sensor pada serial monitor
  Serial.println("Temp : " + String(temperature) + " °C");
  Serial.println("pres : " + String(pressure) + " hPa");
  Serial.println("Alt  : " + String(altitude) + " meter");
  Serial.println();

  // Mengirim data pembacaan sensor ke database
  // Mengirim data suhu ke database *user/gauge1
  // Mengirim data tekanan ke database *user/gauge2
  // Mengirim data ketinggian ke database *user/hlevel1
  Firebase.setInt(fbdo, "/" + user + "/gauge1", temperature);
  Firebase.setInt(fbdo, "/" + user + "/gauge2", pressure);
  Firebase.setInt(fbdo, "/" + user + "/hlevel1", altitude);
  
  // Menampilkan data pada OLED Display
  display.setTextSize(2);  display.setTextColor(WHITE);
  display.setCursor(1,1);  display.print("BMP180");
  display.setTextSize(1);  display.setTextColor(WHITE);
  display.setCursor(1,25); display.print("Temp: " + String(temperature) + " " + (char)247 + "C");
  display.setCursor(1,35); display.print("Pres: " + String(pressure) + " hPa");
  display.setCursor(1,45); display.print("Alt : " + String(altitude) + " m");
  display.display(); display.clearDisplay();
}
